<?php

// If this file is called directly, abort.
defined('WPINC') || die();

include_once(DRAGONIZER_DIR . '/app/glob-dragonizer-functions.php');

if (function_exists('_dr')) {

    if (is_multisite() && !function_exists('is_plugin_active_for_network') || !function_exists('is_plugin_active')) {
        include_once(ABSPATH . '/wp-admin/includes/plugin.php');
    }

    add_action('init', 'dr_locale', 0);

    if (dr_check()) {

        include_once(DRAGONIZER_DIR . '/app/glob-protector.php');

        if (function_exists('dyna_decoder')) {

            defined('DRAGONIZER_INC_DIR') || define('DRAGONIZER_INC_DIR', _dr(DRAGONIZER_DIR, 'app'));
            defined('DRAGONIZER_PAR_DIR') || define('DRAGONIZER_PAR_DIR', _dr(DRAGONIZER_INC_DIR, 'partials'));
            defined('DRAGONIZER_PAR_URL') || define('DRAGONIZER_PAR_URL', _dr(DRAGONIZER_URL, 'app', 'partials'));
            defined('DRAGONIZER_ASE_DIR') || define('DRAGONIZER_ASE_DIR', _dr(DRAGONIZER_DIR, 'assets'));
            defined('DRAGONIZER_ASE_URL') || define('DRAGONIZER_ASE_URL', _dr(DRAGONIZER_URL, 'assets'));
            defined('DRAGONIZER_UP_DIR')  || define('DRAGONIZER_UP_DIR', _dr(WP_CONTENT_DIR, 'uploads', DRAGONIZER_NAME));
            defined('DRAGONIZER_UP_URL')  || define('DRAGONIZER_UP_URL', _dr(WP_CONTENT_URL, 'uploads', DRAGONIZER_NAME));
            defined('DRAGONIZER_UP_BENCHMARK_DIR')  || define('DRAGONIZER_UP_BENCHMARK_DIR', _dr(WP_CONTENT_DIR, 'uploads', DRAGONIZER_NAME . '-benchmark'));
            defined('DRAGONIZER_UP_BENCHMARK_URL')  || define('DRAGONIZER_UP_BENCHMARK_URL', _dr(WP_CONTENT_URL, 'uploads', DRAGONIZER_NAME . '-benchmark'));

            defined('DRAGONIZER_CACHE_DIR') || define('DRAGONIZER_CACHE_DIR', _dr(WP_CONTENT_DIR, 'cache', DRAGONIZER_NAME));
            defined('DRAGONIZER_CACHE_URL') || define('DRAGONIZER_CACHE_URL', _dr(WP_CONTENT_URL, 'cache', DRAGONIZER_NAME));
            defined('DRAGONIZER_ASSETS_CACHE_DIR') || define('DRAGONIZER_ASSETS_CACHE_DIR', _dr(DRAGONIZER_CACHE_DIR, 'assets'));
            defined('DRAGONIZER_ASSETS_CACHE_URL') || define('DRAGONIZER_ASSETS_CACHE_URL', _dr(DRAGONIZER_CACHE_URL, 'assets'));
            defined('DRAGONIZER_CRITICAL_CACHE_DIR') || define('DRAGONIZER_CRITICAL_CACHE_DIR', _dr(DRAGONIZER_CACHE_DIR, 'critical'));
            defined('DRAGONIZER_CRITICAL_CACHE_URL') || define('DRAGONIZER_CRITICAL_CACHE_URL', _dr(DRAGONIZER_CACHE_URL, 'critical'));
            defined('DRAGONIZER_PAGES_CACHE_DIR') || define('DRAGONIZER_PAGES_CACHE_DIR', _dr(DRAGONIZER_CACHE_DIR, 'pages'));
            defined('DRAGONIZER_PAGES_CACHE_URL') || define('DRAGONIZER_PAGES_CACHE_URL', _dr(DRAGONIZER_CACHE_URL, 'pages'));
            defined('DRAGONIZER_OBJECT_CACHE') || define('DRAGONIZER_OBJECT_CACHE', _dr(WP_CONTENT_DIR, 'object-cache.php'));
            defined('DRAGONIZER_ADVANCED_CACHE_FILE') || define('DRAGONIZER_ADVANCED_CACHE_FILE', _dr(WP_CONTENT_DIR, 'advanced-cache.php'));
            defined('DRAGONIZER_ADVANCED_HEADERS_FILE') || define('DRAGONIZER_ADVANCED_HEADERS_FILE', _dr(WP_CONTENT_DIR, 'advanced-http-headers.php'));
            defined('DRAGONIZER_ADVANCED_HEADERS_TEST_FILE') || define('DRAGONIZER_ADVANCED_HEADERS_TEST_FILE', _dr(WP_CONTENT_DIR, 'advanced-http-headers-test.php'));

            include_once(DRAGONIZER_DIR . '/app/class-dragonizer-common.php');
            include_once(DRAGONIZER_DIR . '/app/class-dragonizer-shamsi.php');
            include_once(DRAGONIZER_DIR . '/app/class-dragonizer-empowering.php');

            // Time to turn up the heat
            class_exists('Dragonizer_Core') && (new Dragonizer_Core())->initialize();
        }
    }
}
