<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_wp_tweaks($obj)
{
    $dragonizer_allowed_description_tags = array(
        'em'     => array(),
        'strong' => array(),
        'br'     => array(),
        'span'   => array(
            'style' => array(),
            'class' => array()
        ),
        'a'      => array(
            'href' => array()
        ),
        'p'      => array(
            'style' => array()
        ),
        'bdo'      => array(
            'style' => array()
        ),
        'b'      => array(
            'style' => array()
        )
    );

?>

    <input type="hidden" name="dragonizer_settings[wp_tweaks]" value="">

    <h3 class="dragon-hidden"><?php esc_html_e('Manipulate wordpress options', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('In this section, you can personalize some WordPress features and make your site more likable.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_tweaks_main, 'wp_tweaks'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->wp_tweaks_main as $dragonizer_option_slug => $dragonizer_option) {
                if (empty($dragonizer_option['type'])) {
            ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_tweaks'] ?? null) ? $obj->settings['wp_tweaks'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>

                <?php
                } elseif ($dragonizer_option['type'] === 'editor') {
                ?>

                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['wp_tweaks'][$dragonizer_option_slug] ?? null) ? $obj->settings['wp_tweaks'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                            <?php

                            $content_db = @wp_kses($obj->get('wp_tweaks', 'footer', 'value'), $dragonizer_allowed_description_tags);

                            $content = empty($content_db) ? __($dragonizer_option['default'], 'dragonizer') : $content_db;

                            echo $obj->safe_wp_editor(
                                $content,
                                esc_attr($dragonizer_option_slug . '_fld'),
                                array(
                                    'media_buttons' => false,
                                    'textarea_name' => "dragonizer_settings[wp_tweaks][$dragonizer_option_slug][value]",
                                    'editor_height' => $dragonizer_option['height'],
                                    'editor_css'    => '<style>.wp-editor-container textarea.wp-editor-area{direction: ltr;}</style>',
                                    'tinymce' => array(
                                        'toolbar1' => 'bold,italic,underline,separator,link,unlink,undo,redo,forecolor,removeformat,charmap',
                                        'toolbar2' => ''
                                    ),
                                    'quicktags' => array(
                                        'buttons' => 'link,strong,em,underline'
                                    )
                                )
                            );

                            echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags);

                            ?>
                        </td>
                    </tr>
                <?php
                } elseif ($dragonizer_option['type'] === 'select') {
                ?>

                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['wp_tweaks'][$dragonizer_option_slug] ?? null) ? $obj->settings['wp_tweaks'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">

                            <div class="centered-content">

                                <select id="<?= "{$dragonizer_option_slug}_id" ?>" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug  ?>][value]">
                                    <?php
                                    foreach ($dragonizer_option['values'] as $font) {
                                    ?>
                                        <option value='<?= $font ?>' <?php @selected($obj->settings['wp_tweaks'][$dragonizer_option_slug]['value'] ?? false, $font); ?>><?= __($font, 'dragonizer') ?></option>
                                    <?php
                                    }
                                    ?>
                                </select>

                                <?php if ($dragonizer_option_slug === 'dashboard') { ?>
                                    <table class="color-palette" style="display:inline-table;width:20%;vertical-align:middle;margin:10px 20px" id="color-palette-table">
                                        <tbody>
                                            <tr>
                                                <td style="background-color: transparent">&nbsp;</td>
                                                <td style="background-color: transparent">&nbsp;</td>
                                                <td style="background-color: transparent">&nbsp;</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                <?php } else { ?>
                                    <span id="certificate-container-<?= $dragonizer_option_slug ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="32px" height="32px" viewBox="0 0 512 512">
                                            <g fill="#000">
                                                <path d="M0 77.71c1.53-29.59 30.95-48.68 59-44.42 135.64.16 271.29-.17 406.92.16 22.33-.09 43.11 16.84 46.08 39.21v303.69c-2.31 23.3-24.14 40.47-47.03 40.24-134.99 0-269.98.2-404.96.07-14.32.33-30.05-.64-41.69-9.98C7.06 398.8 2.2 385.28 0 372.26V77.71m43.36-27.26c-17.57.95-28.81 19.01-26.4 35.56.09 91 .02 182 .03 272.99-.08 9.43-.68 19.8 5.06 27.9 6.8 11.17 20.84 13.87 32.96 13.09 136.01-.15 272.03.02 408.04-.02 11.14.35 23.07-4.13 28.68-14.29 7.03-12.35 3.36-27.18 4.27-40.68-.07-88.68.14-177.36-.1-266.03.3-16.77-15.47-30.15-31.85-28.95-140.22.27-280.49-.58-420.69.43Z" opacity="1" />
                                                <path d="M64.01 140.29c29.67.09 59.33.1 89-.01.56 9.49.44 19.01.08 28.5-20.3.13-40.6-.31-60.88.19.01 8.7.01 17.41 0 26.11 18.79.62 37.6-.07 56.39.32.1 9.39.12 18.79-.01 28.19-18.79.37-37.59-.31-56.37.31-.1 17.43.23 34.86-.14 52.29-9.4.31-18.81.32-28.21-.01-.2-45.29-.48-90.61.14-135.89ZM200 196.2c7.39-12.09 22.64-18.98 36.26-13.34.15 8.01.29 16.03-.12 24.04-12.15-3.07-30.3-2.8-34.36 11.92-3.89 18.45-1.15 37.56-1.97 56.29-9.5.33-19.03.49-28.52-.1.1-30.61.12-61.21 0-91.82 9.49-.27 19-.2 28.5-.06-.04 4.36.06 8.72.21 13.07Zm61.39-1.83c16.65-15.19 45.29-18.99 63.22-3.99 14.03 12.18 16.35 32.07 15.33 49.54-21.68.23-43.38-.26-65.05.23 4.54 19.41 32.46 20.9 42.39 5.07 6.78 4.71 13.65 9.33 19.99 14.64-19.21 25.1-61.68 24.48-80.86-.3-14.8-18.81-12.95-49.02 4.98-65.19m13.54 25.26c12.29 0 24.58.18 36.86-.1 1.2-24.07-37.18-23.21-36.86.1Zm86.04-11.66c11.84-25.21 47.69-35.18 70.76-19.67 16.11 11.61 18.98 33.08 17.99 51.52-21.67.46-43.36-.23-65.02.33 4.3 19.57 32.42 20.74 42.33 5.02 6.73 4.64 13.25 9.57 19.94 14.28-18.43 25.45-60.89 24.94-80.26.85-11.85-14.35-13.56-35.69-5.74-52.33m23.85 11.69c12.12.02 24.24-.03 36.36.03 2.16-24.23-37.29-23.46-36.36-.03Z" opacity="1" />
                                            </g>
                                        </svg>
                                        <span>Description Here</span>
                                    </span>
                                <?php } ?>
                            </div>
                            <p style="margin:10px"> <?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?> </p>
                        </td>
                    </tr>

            <?php
                }
            }
            ?>

        </tbody>
    </table>


    <h3 class="dragon-hidden"><?php esc_html_e('Enhance Site Functionality', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>
    <p class="dragon-hidden"><?php esc_html_e('Use this section to fine-tune your WordPress site, optimizing it for better performance and enhanced user experience.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_tweaks_other, 'wp_tweaks'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->wp_tweaks_other as $dragonizer_option_slug => $dragonizer_option) {
                if (empty($dragonizer_option['type'])) {
            ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_tweaks'] ?? null) ? $obj->settings['wp_tweaks'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>

                <?php
                } elseif ($dragonizer_option['type'] === 'editor') {
                ?>

                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['wp_tweaks'][$dragonizer_option_slug] ?? null) ? $obj->settings['wp_tweaks'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                            <?php

                            $content_db = @wp_kses($obj->get('wp_tweaks', 'footer', 'value'), $dragonizer_allowed_description_tags);

                            $content = empty($content_db) ? __($dragonizer_option['default'], 'dragonizer') : $content_db;

                            echo $obj->safe_wp_editor(
                                $content,
                                esc_attr($dragonizer_option_slug . '_fld'),
                                array(
                                    'media_buttons' => false,
                                    'textarea_name' => "dragonizer_settings[wp_tweaks][$dragonizer_option_slug][value]",
                                    'editor_height' => $dragonizer_option['height'],
                                    'editor_css'    => '<style>.wp-editor-container textarea.wp-editor-area{direction: ltr;}</style>',
                                    'tinymce' => array(
                                        'toolbar1' => 'bold,italic,underline,separator,link,unlink,undo,redo,forecolor,removeformat,charmap',
                                        'toolbar2' => ''
                                    ),
                                    'quicktags' => array(
                                        'buttons' => 'link,strong,em,underline'
                                    )
                                )
                            );

                            echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags);

                            ?>
                        </td>
                    </tr>
                <?php
                } elseif ($dragonizer_option['type'] === 'select') {
                ?>

                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['wp_tweaks'][$dragonizer_option_slug] ?? null) ? $obj->settings['wp_tweaks'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">

                            <div class="centered-content">

                                <select id="<?= "{$dragonizer_option_slug}_id" ?>" name="dragonizer_settings[wp_tweaks][<?= $dragonizer_option_slug  ?>][value]">
                                    <?php
                                    foreach ($dragonizer_option['values'] as $font) {
                                    ?>
                                        <option value='<?= $font ?>' <?php @selected($obj->settings['wp_tweaks'][$dragonizer_option_slug]['value'] ?? false, $font); ?>><?= __($font, 'dragonizer') ?></option>
                                    <?php
                                    }
                                    ?>
                                </select>

                                <?php if ($dragonizer_option_slug === 'dashboard') { ?>
                                    <table class="color-palette" style="display:inline-table;width:20%;vertical-align:middle;margin:10px 20px" id="color-palette-table">
                                        <tbody>
                                            <tr>
                                                <td style="background-color: transparent">&nbsp;</td>
                                                <td style="background-color: transparent">&nbsp;</td>
                                                <td style="background-color: transparent">&nbsp;</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                <?php } else { ?>
                                    <span id="certificate-container-<?= $dragonizer_option_slug ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="32px" height="32px" viewBox="0 0 512 512">
                                            <g fill="#000">
                                                <path d="M0 77.71c1.53-29.59 30.95-48.68 59-44.42 135.64.16 271.29-.17 406.92.16 22.33-.09 43.11 16.84 46.08 39.21v303.69c-2.31 23.3-24.14 40.47-47.03 40.24-134.99 0-269.98.2-404.96.07-14.32.33-30.05-.64-41.69-9.98C7.06 398.8 2.2 385.28 0 372.26V77.71m43.36-27.26c-17.57.95-28.81 19.01-26.4 35.56.09 91 .02 182 .03 272.99-.08 9.43-.68 19.8 5.06 27.9 6.8 11.17 20.84 13.87 32.96 13.09 136.01-.15 272.03.02 408.04-.02 11.14.35 23.07-4.13 28.68-14.29 7.03-12.35 3.36-27.18 4.27-40.68-.07-88.68.14-177.36-.1-266.03.3-16.77-15.47-30.15-31.85-28.95-140.22.27-280.49-.58-420.69.43Z" opacity="1" />
                                                <path d="M64.01 140.29c29.67.09 59.33.1 89-.01.56 9.49.44 19.01.08 28.5-20.3.13-40.6-.31-60.88.19.01 8.7.01 17.41 0 26.11 18.79.62 37.6-.07 56.39.32.1 9.39.12 18.79-.01 28.19-18.79.37-37.59-.31-56.37.31-.1 17.43.23 34.86-.14 52.29-9.4.31-18.81.32-28.21-.01-.2-45.29-.48-90.61.14-135.89ZM200 196.2c7.39-12.09 22.64-18.98 36.26-13.34.15 8.01.29 16.03-.12 24.04-12.15-3.07-30.3-2.8-34.36 11.92-3.89 18.45-1.15 37.56-1.97 56.29-9.5.33-19.03.49-28.52-.1.1-30.61.12-61.21 0-91.82 9.49-.27 19-.2 28.5-.06-.04 4.36.06 8.72.21 13.07Zm61.39-1.83c16.65-15.19 45.29-18.99 63.22-3.99 14.03 12.18 16.35 32.07 15.33 49.54-21.68.23-43.38-.26-65.05.23 4.54 19.41 32.46 20.9 42.39 5.07 6.78 4.71 13.65 9.33 19.99 14.64-19.21 25.1-61.68 24.48-80.86-.3-14.8-18.81-12.95-49.02 4.98-65.19m13.54 25.26c12.29 0 24.58.18 36.86-.1 1.2-24.07-37.18-23.21-36.86.1Zm86.04-11.66c11.84-25.21 47.69-35.18 70.76-19.67 16.11 11.61 18.98 33.08 17.99 51.52-21.67.46-43.36-.23-65.02.33 4.3 19.57 32.42 20.74 42.33 5.02 6.73 4.64 13.25 9.57 19.94 14.28-18.43 25.45-60.89 24.94-80.26.85-11.85-14.35-13.56-35.69-5.74-52.33m23.85 11.69c12.12.02 24.24-.03 36.36.03 2.16-24.23-37.29-23.46-36.36-.03Z" opacity="1" />
                                            </g>
                                        </svg>
                                        <span>Description Here</span>
                                    </span>
                                <?php } ?>
                            </div>
                            <p style="margin:10px"> <?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?> </p>
                        </td>
                    </tr>

            <?php
                }
            }
            ?>

        </tbody>
    </table>


    <p class="dragon-hidden"><?php wp_kses(_e('<span style="color: #d94f4f">Notice: </span>Reload the page after saving changes to see the results!', 'dragonizer'), $dragonizer_allowed_description_tags); ?></p>

    <script>
        (function($) {
            $(document).ready(function() {
                var fontsInfo = {
                    'Sahel': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },
                    'Shilia': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },
                    'Vazirmatn': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },
                    'Alibaba': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },
                    'Mikhak': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },
                    'Estedad': {
                        isFree: true,
                        description: '<?= __('This is a free font', 'dragonizer') ?>'
                    },

                    // Paid fonts with descriptions and URLs.
                    'Pinar': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontamin.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontamin.com/licenses/?type=%D8%AF%D8%B1%D8%A7%DA%AF%D9%88%D9%86%D8%A7%DB%8C%D8%B2%D8%B1'
                    },
                    'YekanBakh': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/QWYT40OJ'
                    },
                    'IRANSansDN': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/O1WHGRV9'
                    },
                    'IRANSansX': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/A9JTO6WH'
                    },
                    'IRANYekanX': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/AU1FYQ47'
                    },
                    'Kalameh': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/1NOAW8S3'
                    },
                    'Pelak': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/QYZ8H3L7'
                    },
                    'Peyda': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/3A7TV8U9'
                    },
                    'Borna': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/0ZXK25UJ'
                    },
                    'Dana': {
                        isFree: false,
                        description: '<?= __('This font was legally purchased from fontiran.com website (special license for sales templates).', 'dragonizer') ?>',
                        url: 'https://fontiran.com/license/9FYHUEL1'
                    }
                };

                function handleMutation(mutationRecords) {
                    mutationRecords.forEach(function(mutation) {
                        // Filter out irrelevant mutations.
                        if (mutation.type !== 'attributes' || mutation.attributeName !== 'disabled') {
                            return;
                        }

                        var $target = $(mutation.target);
                        var isDisabled = $target.is(':disabled');
                        var $certificateContainer = $target.siblings('span[id^="certificate-container"]');

                        // Update the certificate if the target is not disabled or if the certificate container doesn't exist.
                        if (!isDisabled || $certificateContainer.length === 0) {
                            updateCertificate($target);
                        }

                        // Toggle the visibility of the certificate container if it exists.
                        if ($certificateContainer.length > 0) {
                            $certificateContainer.toggle(!isDisabled);
                        }
                    });
                }

                var observer = new MutationObserver(handleMutation);

                // Select the target nodes
                var selectElements = $('select[id$="_id"]'); // This selects all elements whose id ends with '_id'

                // Observe each select element
                selectElements.each(function() {
                    observer.observe(this, {
                        attributes: true, // Observing changes to attributes
                        attributeFilter: ['disabled'] // Specifically, the 'disabled' attribute
                    });
                });

                function updateCertificate(selectElement) {
                    if (selectElement.is(':disabled')) {
                        selectElement.closest('.centered-content').find('span[id^="certificate-container-"]').empty();
                        return; // If select is disabled, clear any certificate info and return.
                    }

                    var selectedFont = selectElement.val();
                    var fontInfo = fontsInfo[selectedFont];

                    // If the font information doesn't exist in our dictionary, you might want to handle this (e.g., clear the certificate info or show a default message).
                    if (!fontInfo) {
                        selectElement.closest('.centered-content').find('span[id^="certificate-container-"]').empty();
                        return;
                    }

                    var certificateContainer = selectElement.closest('.centered-content').find('span[id^="certificate-container-"]');

                    certificateContainer.removeClass('fade-in');
                    // Force reflow, allowing the class to be reapplied and animation restarted. This is a common trick to restart CSS animations in JavaScript.
                    void certificateContainer[0].offsetWidth;
                    certificateContainer.addClass('fade-in');

                    if (fontInfo.isFree) {
                        var content = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 512 512"><g fill="#000"><path d="M0 77.76c1.49-29.64 30.95-48.69 59.01-44.5 135.32.19 270.65-.12 405.97.16 22.63-.45 44.04 16.51 47.02 39.26v303.65c-2.3 23.27-24.15 40.56-47.05 40.22-134.97.06-269.96.22-404.94.12-12.27.17-25.3-.3-36.28-6.4C9.51 402.92 2.09 387.5 0 372.22V77.76m43.37-27.32c-13.41.92-25.09 12.34-26.02 25.8-.8 97.58-.14 195.22-.33 292.82-1.02 16.57 13.37 31.36 29.97 30.79 139.34.14 278.71.16 418.06.04 16.48.91 31.54-13.17 30.89-29.83.07-97.02.16-194.06-.04-291.07.3-16.79-15.45-30.18-31.84-28.96-140.23.25-280.5-.57-420.69.41Z" opacity="1"/><path d="M63.8 146.01c33.46-.09 66.92-.09 100.38 0 .23 5.97.22 11.95-.01 17.92-26.96.17-53.93-.2-80.89.18.15 14.9.15 29.81.01 44.72 23.45.33 46.91-.22 70.37.27.17 5.92-.1 11.83-.39 17.74-23.32.02-46.66-.36-69.98.18.1 22.66.23 45.32-.05 67.98-6.48.15-12.96.15-19.44 0-.21-49.66-.21-99.33 0-148.99Zm202.14 50.95c15.08-13.37 38.58-14.74 56.36-6.26 19.32 9.99 26.95 33.59 25.02 54.15-26.87-.08-53.74-.22-80.61.06.6 11.43 4.25 23.49 13.27 31.11 16.03 13.53 42.4 5.09 48.21-14.99 6.4.67 12.81 1.34 19.18 2.26-7.61 38.74-65.38 44.69-87.57 15.89-16.79-23.96-15.18-61.43 6.14-82.22m2.59 33.23c19.8.32 39.61.32 59.41.01-.04-17.2-15.07-33.24-32.92-30.16-15.23.98-26.13 15.55-26.49 30.15Zm112.41-33.23c14.9-13.23 38-14.65 55.7-6.6 19.75 9.76 27.66 33.7 25.68 54.49-26.87-.08-53.74-.22-80.6.06.59 11.43 4.25 23.49 13.26 31.11 16.03 13.53 42.4 5.08 48.21-14.99 6.4.67 12.81 1.34 19.18 2.26-7.63 38.74-65.38 44.69-87.57 15.89-16.79-23.95-15.17-61.43 6.14-82.22m2.59 33.23c19.8.32 39.61.32 59.41.01-.03-17.21-15.07-33.24-32.92-30.17-15.23.99-26.13 15.56-26.49 30.16ZM204 203.13c6.99-16.01 26.48-23.1 41.08-12.17-1.85 5.39-3.86 10.73-6.11 15.96-7.45-3.37-17.04-5.64-24.02.01-7.43 6.73-8.43 17.64-9.19 27.06-.24 20.3-.12 40.61-.03 60.92-5.98.23-11.96.27-17.94.09-.16-35.9-.33-71.82.09-107.73 5.29.02 10.59.03 15.89.01-.06 5.28.07 10.57.23 15.85Z" opacity="1"/></g></svg>';
                    } else {
                        var content = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 512 512"><g fill="#000"><path d="M0 77.69c1.55-29.56 30.95-48.68 59-44.38 135.64.11 271.3-.16 406.94.13 22.32-.05 43.08 16.84 46.06 39.22v303.7c-2.32 22.99-24.17 41.12-47.08 39.74-9.26-2.32-6.43-16.77 2.93-16.27 17.76-.45 30.46-17.72 28.2-34.82-.09-93.68-.07-187.36-.01-281.03.8-11.53-3.89-23.9-14.34-29.72-9.28-5.39-20.42-4.14-30.7-4.25-133.01-.02-266.02.06-399.03-.04-17.23-2.16-35.31 10.82-34.86 29.02-.29 95.67.03 191.36-.15 287.04-1.95 16.67 10.87 33.58 28.17 33.67 48.87.81 97.83-.34 146.68.56 10.91 1.03 7.7 18.32-2.84 16.38-48.12-.26-96.3.54-144.39-.4-23.77-.57-42.71-20.77-44.58-43.95V77.69Z" opacity="1"/><path d="M88.38 105.48c26.45-.31 52.93-.18 79.39-.07 9.57-.38 17.53 8.16 17.13 17.6.13 25.96.25 51.95-.06 77.9.18 9.13-7.62 17.27-16.84 17-26.33.18-52.67.18-78.99 0-9.23.27-17.02-7.86-16.85-17-.31-25.96-.2-51.94-.06-77.9-.34-9.06 7-17.58 16.28-17.53m.8 16.7c-.31 26.26-.3 52.57 0 78.82 26.17.54 52.46.55 78.64 0 .3-26.26.31-52.57-.01-78.82-26.19-.29-52.44-.28-78.63 0Zm224.87 41.76c35.42-8.21 74.56 4.11 98.97 31.03 36.38 37.49 36.34 101.65 1.57 140.16 10.6 38.77 22.69 77.24 33.44 116 2.22 7.13-6.19 12.94-12.36 9.21-11.52-5.04-22.59-11.23-34.3-15.77-7.45 10.49-14.58 21.25-22.11 31.68-3.74 5.61-13.28 3.74-14.64-2.85-9.45-34.35-18.37-68.88-27.83-103.23-12.11 33-18.89 70.44-29.7 104.89-2.27 5.29-10.26 6.1-13.65 1.48-7.96-10.39-14.56-21.82-22.65-32.1-12.28 4.85-23.75 11.68-36.03 16.54-5.83 2.28-12.54-3.66-10.5-9.72 10.77-39.08 23.34-77.81 33.5-117-24.11-28.04-32.35-68.85-19.37-103.73 11.57-33.2 41.24-59.34 75.66-66.59m17.36 14.5c-49.36 1.42-89.88 50.87-81.41 99.58 4.78 38.08 37.63 70.44 75.87 74.3 29.87 4.06 61.24-8.98 79.49-32.95 27.03-32.96 23.8-85.35-6.62-115.1-17.44-17.63-42.52-27.52-67.33-25.83M271.48 348.4c-8.39 29.57-17.65 58.95-25.51 88.66 10.47-2.65 19.32-11.87 30.34-11.4 9.06 6.4 12.99 17.92 20.3 26.14 6.8-27.96 15.18-55.56 21.89-83.52-17.19-2.48-32.56-11.64-47.02-19.88m82.68 20c6.37 27.77 14.3 55.32 21.93 82.81 7.43-7.78 11.06-19.27 20.07-25.28 11.16-.21 20.34 8.41 30.74 11.76-8.7-29.85-17.32-59.73-26.17-89.53-14.02 9.72-29.66 17.22-46.57 20.24Z" opacity="1"/><path d="M336.14 217.66c21.67.2 42.89 15.83 46.67 37.6 6.85 24.72-11.31 53.06-36.73 56.86-25.25 6.59-53.59-12.84-56.44-38.84-5.99-27.84 18.41-55.67 46.5-55.62m-1.73 16.79c-17.62.71-32.02 18.47-28.76 35.85 1.9 16.74 19.33 29.37 35.82 26.18 16.58-2.11 28.98-19.38 25.85-35.77-2.06-15.54-17.33-27.61-32.91-26.26ZM80.35 257.49c32.35-.21 64.77-.43 97.1.11 9.82.34 9.16 16.35-.5 16.25-32.28.28-64.62.28-96.9 0-10.16.01-10.02-16.8.3-16.36Zm-2.92 52.96c33.06-1.54 66.43-.47 99.59-.53 9.92-.08 9.98 16.42 0 16.26-32.33.25-64.7.25-97.04 0-8.51.2-10.48-13.13-2.55-15.73Z" opacity="1"/></g></svg>';
                    }

                    content += '<span>' + fontInfo.description + '</span>'; // Add description with style.

                    // If it's not a free font, add a link.
                    if (!fontInfo.isFree) {
                        content += '&nbsp;<a style="color:darkred;font-weight:600" href="' + fontInfo.url + '" target="_blank"><?= __('(More Info)', 'dragonizer') ?></a>';
                    }

                    certificateContainer.html(content);
                }

                // Handle dynamically created select elements and initial page load
                function initializeCertificates() {
                    $('select[id$="_id"]').each(function() {
                        updateCertificate($(this)); // Check each select on page load.
                    });
                }

                // Direct binding for future dynamically created selects.
                $(document).on('change', 'select[id$="_id"]', function() {
                    updateCertificate($(this));
                });

                // Handle the case when selects are dynamically enabled/disabled.
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'attributes' && mutation.attributeName === 'disabled') {
                            updateCertificate($(mutation.target));
                        }
                    });
                });

                $('select[id$="_id"]').each(function() {
                    updateCertificate($(this));
                });

                // Initial setup on page load.
                initializeCertificates();
            });
        })(jQuery);
    </script>


    <style>
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .fade-in {
            animation: fadeIn 1s ease-in-out;
        }

        .centered-content {
            display: flex;
            gap: 10px;
        }

        .centered-content svg {
            margin: 5px;
            height: 32px;
            width: 32px;
        }

        .centered-content span {
            display: flex;
            align-items: center;
        }

        .centered-content span:nth-child(2) {
            line-height: 1;
        }
    </style>

    <script>
        (function() {
            "use strict";

            // This function toggles the 'disabled' attribute based on the checkbox state.
            function toggleSelectState(checkbox) {
                const tr = checkbox.closest('tr');
                if (tr) {
                    const select = tr.querySelector('select');
                    if (select) {
                        if (checkbox.checked) {
                            select.removeAttribute('disabled');
                        } else {
                            select.setAttribute('disabled', 'disabled');
                        }
                    }
                }
            }

            // Get all the checkboxes
            const checkboxes = document.querySelectorAll('input[type="checkbox"]');

            // Loop through them
            checkboxes.forEach(function(checkbox) {

                // First, handle the current state on page load
                toggleSelectState(checkbox);

                // We are going to create a new property descriptor to customize checkbox behavior
                const originalPropDescriptor = Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, 'checked');

                // Redefine the 'checked' property
                Object.defineProperty(checkbox, 'checked', {
                    configurable: true,
                    get: function() {
                        return originalPropDescriptor.get.call(this);
                    },
                    set: function(value) {
                        // When the 'checked' property changes, run our custom function
                        originalPropDescriptor.set.call(this, value);
                        toggleSelectState(this); // "this" is the checkbox
                    }
                });

                // Also, listen for changes to ensure UI updates for user-initiated interactions
                checkbox.addEventListener('change', function() {
                    toggleSelectState(checkbox);
                });
            });

        })();
    </script>

    <script>
        (function() {
            "use strict";

            var colorSelect = document.getElementById('dashboard_id');
            var tds = document.querySelectorAll('#color-palette-table td');

            if (!colorSelect || tds.length === 0) {
                console.error('Select element or td elements not found!');
                return; // This is now valid, because we're inside a function
            }

            var defaultColors = ['transparent', 'transparent', 'transparent']; // Define your default colors here
            var colors = {
                'Special': ['#4f56a9', '#cda200', '#a84808'],
                'Luxury': ['#4f56a9', '#cda200', '#79b591'],
                'Vineyard': ['#573e48', '#462b36', '#cc9e14'],
                'Nostalgia': ['#0c4da1', '#d13674', '#28b811'],
                'Lavender': ['#5c5b73', '#353354', '#ba5b32'],
                'Seashore': ['#e1dbc5', '#533c30', '#456a7f'],
                'Gray': ['#e5e5e5', '#7e8993', '#d64e07'],
                'Excitement': ['#5f1b29', '#bd3854', '#dc3232'],
                'Calm': ['#2c3e50', '#79b591', '#a84808'],
                'Lawn': ['#1E2A29', '#2d3f3d', '#a7b145'],
                'Jade': ['#1e8060', '#0f4232', '#1e1e1e'],
                'Night': ['#040404', '#495158', '#666666'],
                'Gum': ['#7e8993', '#607d8b', '#ff5252'],
                'Chocolate': ['#a97654', '#5d4037', '#d35401'],
            };

            function updateColor() {
                var selectedColors;

                // Check if the select element is disabled
                if (colorSelect.disabled) {
                    // If disabled, use default colors
                    selectedColors = defaultColors;
                } else {
                    // If not disabled, proceed as normal
                    var selectedValue = colorSelect.value;
                    selectedColors = colors[selectedValue] || defaultColors; // Use the selected color or default if not found
                }

                tds.forEach(function(td, index) {
                    td.style.backgroundColor = selectedColors[index];
                });
            }

            // Update colors on initial load
            updateColor();

            // Add event listener for change event
            colorSelect.addEventListener('change', updateColor);

            // Create a mutation observer to watch for changes in the 'disabled' attribute
            var observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'disabled') {
                        updateColor(); // Call update function when 'disabled' attribute changes
                    }
                });
            });

            // Start observing the select element for attribute changes
            observer.observe(colorSelect, {
                attributes: true // Configure it to listen to attribute changes
            });
        })();
    </script>

<?php
}
