<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_wp_optimizer($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'span' => array(
            'style' => array(),
        ),
        'a' => array(
            'href' => array(),
            'target' => array(),
        ),
    );

?>

    <input type="hidden" name="dragonizer_settings[wp_optimizer]" value="">

    <h3 class="dragon-hidden"><?php esc_html_e('Feature Cleanup', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_warning_badge"><?php esc_html_e('Usually safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('This section goes further disabling optional features. All options can be safely activated, but keep an eye on potential plugin compatibility issues.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_optimize-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_optimizer_optimize, 'wp_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php

            foreach ($obj->wp_optimizer_optimize as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[wp_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_optimizer'] ?? null) ? $obj->settings['wp_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

    <h3 class="dragon-hidden"><?php esc_html_e('Optimization Tweaks', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_danger_badge"><?php esc_html_e('Handle with care', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('Options in this section have the most impact on WordPress performance, but also the most potential of screwing things up.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_tweaks-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_optimizer_tweaks, 'wp_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>

        <tbody>
            <?php foreach ($obj->wp_optimizer_tweaks as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[wp_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_optimizer'] ?? null) ? $obj->settings['wp_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <h3 class="dragon-hidden"><?php esc_html_e('Disable main options', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_danger_badge"><?php esc_html_e('Handle with care', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('Activate the options in this section only if necessary or temporarily.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_tweaks-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_optimizer_core, 'wp_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>

        <tbody>
            <?php foreach ($obj->wp_optimizer_core as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[wp_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_optimizer'] ?? null) ? $obj->settings['wp_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <h3 class="dragon-hidden"><?php esc_html_e('Third-party plugins bloat', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('Disable unnecessary features of the third-party plugins installed in your site.', 'dragonizer'); ?></p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->wp_optimizer_other, 'wp_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->wp_optimizer_other as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[wp_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['wp_optimizer'] ?? null) ? $obj->settings['wp_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

<?php
}
