<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_shamsi($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'span' => array(
            'style' => array(),
        ),
        'a' => array(
            'href' => array(),
            'target' => array(),
        ),
    );

    $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

    $plugins = array_filter($obj->bad_plugins['shamsi'], $callback);

    if (count($plugins) > 0) : ?>
        <p class="dragon-hidden" style="font-size: larger;"><i style="margin:5px;color:orange" class="dashicons dashicons-admin-plugins"></i><?php _e('To use this section, please <strong>disable</strong> the following plugins first. There are all features of these plugins with better performance in Dragonizer.', 'dragonizer'); ?></p>
        <table class="dragon-hidden" style="margin:0 auto; border-spacing: 5px;text-align: left;">
            <tbody>
                <?php
                foreach ($plugins as $plugin) {
                    $plugin_data = get_plugin_data(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $plugin);
                ?>
                    <tr>
                        <td><strong><span style="text-decoration: line-through;text-decoration-color: red;"><?= esc_attr($plugin_data['Name']) ?></span></strong></td>
                        <td><a href="<?= esc_url_raw(wp_nonce_url(admin_url('admin-post.php?action=deactivate_plugin&plugin=' . rawurlencode($plugin)), 'deactivate_plugin')) ?>" style="line-height: 22px!important;" class="button button-secondaty deactive-bad-plugins"><?= esc_html__('Deactivate', 'dragonizer') ?><span class="dashicons dashicons-trash"></span></a></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>

        <script>
            (function($) {
                $(function() {
                    $('a.deactive-bad-plugins').on('click', function() {
                        $('.dragonizer_tab_group #loader-wrapper').removeClass('loaded');
                    });
                });
            })(jQuery);
        </script>

    <?php else : ?>

        <input type="hidden" name="dragonizer_settings[shamsi]" value="">

        <h3 class="dragon-hidden"><?php esc_html_e('Main Settings', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

        <p class="dragon-hidden"><?php esc_html_e('With the help of this section, add Jalali date to your site.', 'dragonizer'); ?></p>

        <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_optimize-table">
            <thead>
                <tr>
                    <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" id="dragonizer_shamsi_checkall_fld" <?php @checked(true, $obj->all_options_checked($obj->shamsi, 'shamsi'), true); ?>></td>
                    <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                    <th>
                        <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($obj->shamsi as $dragonizer_option_slug => $dragonizer_option) { ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[shamsi][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['shamsi'] ?? null) ? $obj->settings['shamsi'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>

                <?php } ?>

            </tbody>
        </table>

        <script>
            (function($) {
                $(document).ready(function() {
                    if ($('#fix_woocommerce_fld').prop("checked")) {
                        $('#Woo_shamsi_settings').fadeIn('slow');
                    }

                    $('#fix_woocommerce_fld').change(function() {
                        if (this.checked)
                            $('#Woo_shamsi_settings').fadeIn('slow');
                        else
                            $('#Woo_shamsi_settings').fadeOut('slow');
                    });

                    $('#dragonizer_shamsi_checkall_fld').change(function() {
                        $('#fix_woocommerce_fld').trigger('change');
                    });
                });
            })(jQuery);
        </script>

        <div class="dragon-hidden" id="Woo_shamsi_settings" style="display: none;">

            <h3 class="dragon-hidden"><?php esc_html_e('Woocommerce Settings', 'dragonizer'); ?></h3>

            <p class="dragon-hidden" style="color:green"><?php esc_html_e('Shamsi woocommerce is currently enabled and all dates and datepickers converted to shamsi in different sections, but in addition, you can also apply the following to your site.', 'dragonizer'); ?></p>

            <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_optimize-table">
                <thead>
                    <tr>
                        <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" id="dragonizer_shamsi_woocommerce_checkall_fld" <?php @checked(true, $obj->all_options_checked($obj->shamsi_woocommerce, 'shamsi'), true); ?>></td>
                        <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                        <th>
                            <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($obj->shamsi_woocommerce as $dragonizer_option_slug => $dragonizer_option) { ?>
                        <tr>
                            <th scope="row" class="check-column">
                                <input type="checkbox" name="dragonizer_settings[shamsi][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['shamsi'] ?? null) ? $obj->settings['shamsi'] : [])), true); ?>>
                            </th>
                            <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                            </td>
                            <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                        </tr>

                    <?php } ?>

                </tbody>
            </table>
        </div>

        <p class="dragon-hidden"><?php wp_kses(_e('<span style="color: #d94f4f">Notice: </span>Reload the page after saving changes to see the results!', 'dragonizer'), $dragonizer_allowed_description_tags); ?></p>

    <?php
    endif;
    ?>

<?php
}
