<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_settings($obj)
{

?>

    <p class="dragon-hidden"><?php _e('In this section, you can reset, import or export settings of Dragonizer.', 'dragonizer'); ?></p>

    <br>

    <form method="post">
        <input style="display:none" type="submit" value="NONE" name="submit">
    </form>

    <div class="dragon-hidden dragonizer-docs-section">
        <table class="form-table">

            <tr valign="top">
                <th scope="row">
                    <span style="font-weight:bold;display:flex"><img style="padding: 0 5px 0 5px;width:16px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/notice-default.svg') ?>">
                        <?php esc_html_e('Temporary deactivation', 'dragonizer'); ?></span>
                    <p style="color:gray;font-size:smaller;padding:10px 5px"><?php esc_html_e('Temporarily deactive Dragonizer', 'dragonizer'); ?></p>
                </th>

                <td style="vertical-align:top">
                    <a style="appearance:button;width:0;height:0" href="<?= wp_nonce_url(admin_url('admin-post.php?action=dragonizer_disable&dragonizer_disable=true&_wp_http_referer=' . add_query_arg(array('page' => "dragonizer_settings"), admin_url('admin.php'))), 'dragonizer-secret'); ?>">
                        <input type="button" id="temporary_deactive" class="button button-secondary" value="<?php esc_html_e('Deactive', 'dragonizer'); ?>">
                    </a>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">
                    <span style="font-weight:bold;display:flex"><img style="padding: 0 5px 0 5px;width:16px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/notice-error.svg') ?>">
                        <?php esc_html_e('Reset All Settings', 'dragonizer'); ?></span>
                    <p style="color:gray;font-size:smaller;padding:10px 5px"><?php esc_html_e('Fabric reset to plugin configuration', 'dragonizer'); ?></p>
                </th>

                <td style="vertical-align:top">
                    <input type="button" id="reset_settings" class="button button-secondary" value="<?php esc_html_e('Reset', 'dragonizer'); ?>">
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">
                    <span style="font-weight:bold;display:flex"><img style="padding: 0 5px 0 5px;width:16px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/export.svg') ?>">
                        <?php esc_html_e('Export', 'dragonizer'); ?></span>
                    <p style="color:gray;font-size:smaller;padding:10px 5px"><?php esc_html_e('Export settings as a json file', 'dragonizer'); ?></p>
                </th>

                <td style="vertical-align:top">
                    <a style="appearance:button;width:0;height:0" href="<?= esc_url(add_query_arg(array('page' => "dragonizer_settings", 'dragonizer_export' => 'true', 'dragonizer_secret' => wp_create_nonce('dragonizer_export')), admin_url('admin.php'))); ?>">
                        <input type="button" id="export_settings" class="button button-secondary" value="<?php esc_html_e('Export', 'dragonizer'); ?>">
                    </a>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">
                    <span style="font-weight:bold;display:flex"><img style="padding: 0 5px 0 5px;width:16px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/import.svg') ?>">
                        <?php esc_html_e('Import', 'dragonizer'); ?></span>
                    <p style="color:gray;font-size:smaller;padding:10px 5px"><?php esc_html_e('Import settings via json file', 'dragonizer'); ?></p>
                </th>

                <td style="vertical-align:top">

                    <form method="post" enctype="multipart/form-data">
                        <div class="file-upload">

                            <div class="dragonizer-upload" id="dragonizer-import-upload-wrap">
                                <input id="dragonizer-import-file-input" class="dragonizer-file-input" name="imported_file" type="file" value="" readonly="readonly" accept=".json">
                                <label class="dragonizer-upload-button" type="button" for="dragonizer-import-file-input">
                                    <span class="dragonizer-icon-upload-cloud" aria-hidden="true"></span>
                                    <?php esc_html_e('Choose file', 'dragonizer'); ?>
                                </label>
                                <div class="dragonizer-upload-file">
                                    <span id="dragonizer-import-file-name"></span>
                                </div>

                                <input disabled id="dragonizer-import-btn" type="submit" value="<?php esc_html_e('Upload file', 'dragonizer'); ?>" class="button button-secondary button-upload" name="submit">
                            </div>
                        </div>

                    </form>

                </td>
            </tr>

        </table>

    </div>

    <style>
        .dragonizer-docs-section {
            border: 1px solid #ddd;
            padding: 1.5rem;
            background: #fff;
            border-radius: 7px;
        }

        .dragonizer-docs-section h4 {
            margin: 1.5rem 0 1rem;
            font-size: 1rem;
        }

        .dragonizer-docs-section h4:first-child {
            margin-top: 0;
        }
    </style>

    <br>

    <div class="dragon-hidden">
        <h3>
            <?php esc_html_e('Customize Cache Signature', 'dragonizer'); ?>
            <span class="dragonizer_security_badge dragonizer_safe_badge">
                <?php esc_html_e('Completely safe', 'dragonizer'); ?>
            </span>
        </h3>

        <p>
            <?php esc_html_e('Customize the signature that appears at the bottom of your cached pages. You can modify the format and information displayed while maintaining essential cache details.', 'dragonizer'); ?>
        </p>

        <div class="dragonizer-docs-section">
            <h4><?php esc_html_e('Usage Example', 'dragonizer'); ?></h4>
            <pre><code>define('DRAGONIZER_SIGNATURE', "Optimized by Dragonizer v{version} | Size: {page_size}KB | Cached: {time}");</code></pre>

            <h4><?php esc_html_e('Available Variables', 'dragonizer'); ?></h4>
            <ul>
                <li><code>{version}</code> - <?php esc_html_e('Current version of Dragonizer', 'dragonizer'); ?></li>
                <li><code>{page_size}</code> - <?php esc_html_e('Cached page size in KB', 'dragonizer'); ?></li>
                <li><code>{time}</code> - <?php esc_html_e('Cache creation timestamp', 'dragonizer'); ?></li>
            </ul>

            <h4><?php esc_html_e('Important Notes', 'dragonizer'); ?></h4>
            <ul>
                <li><?php esc_html_e('Only alphanumeric characters and basic punctuation are allowed', 'dragonizer'); ?></li>
                <li><?php esc_html_e('HTML tags will be automatically stripped for security', 'dragonizer'); ?></li>
                <li><?php esc_html_e('The signature will be automatically added at the end of the HTML source', 'dragonizer'); ?></li>
            </ul>

            <div>
                <h4><?php esc_html_e('Output Example', 'dragonizer'); ?></h4>
                <pre><code><?php echo esc_html('<!-- Optimized by Dragonizer v' . DRAGONIZER_VER . ' | Size: 45.23KB | Cached: ' . dr_to_shamsi() . ' -->') ?></code></pre>
            </div>
        </div>
    </div>

    <br>

    <div class="dragon-hidden">
        <h3>
            <?php esc_html_e('Customize Login Page Credit', 'dragonizer'); ?>
            <span class="dragonizer_security_badge dragonizer_safe_badge">
                <?php esc_html_e('Completely safe', 'dragonizer'); ?>
            </span>
        </h3>

        <p>
            <?php esc_html_e('Customize the credit text that appears at the bottom of your custom login page.', 'dragonizer'); ?>
        </p>

        <div class="dragonizer-docs-section">
            <h4><?php esc_html_e('Usage Example', 'dragonizer'); ?></h4>
            <pre><code>define('DRAGONIZER_POWERED', "Powered by Dragonizer {version}");</code></pre>

            <h4><?php esc_html_e('Available Variables', 'dragonizer'); ?></h4>
            <ul>
                <li><code>{version}</code> - <?php esc_html_e('Current version of Dragonizer', 'dragonizer'); ?></li>
            </ul>

            <h4><?php esc_html_e('Important Notes', 'dragonizer'); ?></h4>
            <ul>
                <li><?php esc_html_e('Only alphanumeric characters and basic punctuation are allowed', 'dragonizer'); ?></li>
                <li><?php esc_html_e('HTML tags will be automatically stripped for security', 'dragonizer'); ?></li>
                <li><?php esc_html_e('The text will be displayed at the bottom of your custom login page', 'dragonizer'); ?></li>
            </ul>

            <div>
                <h4><?php esc_html_e('Output Example', 'dragonizer'); ?></h4>
                <pre><code><?php echo esc_html('Powered by Dragonizer v' . DRAGONIZER_VER) ?></code></pre>
            </div>
        </div>
    </div>

    <br>
    <br>

    <style type="text/css">
        .dragonizer-upload.dragonizer-has_file .dragonizer-upload-file,
        .dragonizer-upload.dragonizer-has_file .dragonizer-upload-image .dragonizer-image-preview {
            display: block
        }

        .dragonizer-upload.dragonizer-has_file .dragonizer-upload-button {
            display: none
        }

        .rtl .dragonizer-upload .button-upload {
            border-radius: 8px 0 0 8px;
        }

        .dragonizer-upload .button-upload {
            border-radius: 0 8px 8px 0;
        }

        .dragonizer-form-field:last-child {
            margin-bottom: 0;
        }

        @media (min-width: 783px) {
            .dragonizer-form-field {
                margin-bottom: 30px;
            }
        }

        .dragonizer-upload {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            max-width: 100%;
        }

        .dragonizer-upload input[type=file] {
            clip: rect(1px, 1px, 1px, 1px);
            word-wrap: normal !important;
            border: 0;
            -webkit-clip-path: inset(50%);
            clip-path: inset(50%);
            height: 1px;
            margin: -1px;
            min-height: 1px;
            min-width: 1px;
            overflow: hidden;
            padding: 0;
            position: absolute !important;
            width: 1px;
        }

        .dragonizer-upload .dragonizer-upload-button {
            background-color: transparent;
            border: 1px dashed #ddd;
            border-radius: 8px 0 0 8px;
            color: #aaa;
            letter-spacing: -.25px;
            margin: 0;
            padding: 11px 19px;
        }

        .rtl .dragonizer-upload .dragonizer-upload-button {
            border-radius: 0 8px 8px 0;
        }

        .dragonizer-upload label[for] {
            cursor: pointer;
        }

        .dragonizer-upload label {
            cursor: default;
        }

        .dragonizer-upload .dragonizer-upload-file {
            -webkit-box-flex: 0;
            word-wrap: break-word;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px 0 0 8px;
            cursor: pointer;
            display: none;
            -ms-flex: 0 0 auto;
            flex: 0 0 auto;
            max-width: 180px;
            padding: 11px 11px 11px 11px;
            position: relative;
            -webkit-transition: .3s ease;
            transition: .3s ease;
        }

        .rtl .dragonizer-upload .dragonizer-upload-file {
            border-radius: 0 8px 8px 0;
        }

        .dragonizer-upload .dragonizer-upload-file span {
            color: #333;
            display: block;
            font: 500 9pt/1pc Roboto, Arial, sans-serif;
            letter-spacing: -.25px;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
    </style>

    <style type="text/css">
        .drag-dr-modal {
            position: fixed;
            text-align: center;
            z-index: 99999999;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            display: none;
            background: -webkit-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
            background: -moz-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
            background: radial-gradient(to bottom right, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
            backdrop-filter: blur(3px);
            box-sizing: border-box;
            overflow: hidden
        }

        .drag-dr-modal * {
            box-sizing: border-box
        }

        .drag-dr-modal-wrap {
            max-width: 480px;
            width: 100%;
            position: relative;
            margin-left: auto;
            margin-right: auto;
            top: 50%;
            transform: translate(0, -50%);
            background: #fff;
            border-radius: 8px;
            overflow: hidden
        }

        .drag-dr-modal-header {
            border-bottom: 1px solid #E8E8E8;
            padding: 20px 20px 18px 20px
        }

        .drag-dr-modal-header h3 {
            line-height: 1.8;
            margin: 0;
            color: #4A5568
        }

        .drag-dr-modal-footer {
            border-top: 1px solid #E8E8E8;
            padding: 20px;
            text-align: center
        }

        .drag-dr-button-secondary {
            border: 1px solid #EBEBEB;
            border-radius: 3px;
            font-size: 13px;
            line-height: 1.5;
            padding: 5px 12px;
            cursor: pointer;
            background-color: transparent;
            text-decoration: none
        }

        .drag-dr-submit-modal {
            border: 1px solid #9d0110;
            background-color: #9d0110;
            border-radius: 3px;
            font-size: 13px;
            line-height: 1.5;
            color: #fff;
            padding: 5px 12px;
            cursor: pointer;
            margin-left: 4px
        }

        .drag-dr-hidden {
            opacity: 0;
            display: none
        }

        .drag-dr-over-disabled {
            height: 100%;
            width: 100%;
            opacity: 0.5;
            background-color: #c3c4c7;
            position: absolute;
            z-index: 999999
        }
    </style>

    <div class="drag-dr-modal" id="dragonizer-drag-dr-modal">
        <div class="drag-dr-modal-wrap">
            <div class="drag-dr-over-disabled drag-dr-hidden"></div>
            <div class="drag-dr-modal-header">
                <h3><?php _e('Are you sure you want to reset all dragonizer settings?', 'dragonizer'); ?></h3>
            </div>
            <div class="drag-dr-modal-footer">
                <button type="button" class="drag-dr-submit-modal"><?php _e('Reset', 'dragonizer'); ?></button>
                <button type="button" class="drag-dr-cancel-modal drag-dr-button-secondary"><?php _e('Cancel', 'dragonizer'); ?></button>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        (function($) {
            $(function() {

                var dra_loader = $('.dragonizer_tab_group #loader-wrapper');

                $('.file-upload').on('change', '#dragonizer-import-file-input', function() {
                    const elm = $(this)[0];
                    if (elm.files.length) {
                        const file = elm.files[0];
                        $('#dragonizer-import-file-name').text(file.name);
                        $('#dragonizer-import-upload-wrap').addClass('dragonizer-has_file');
                        $('#dragonizer-import-btn').removeAttr('disabled');
                    } else {
                        $('#dragonizer-import-file-name').text('');
                        $('#dragonizer-import-upload-wrap').removeClass('dragonizer-has_file');
                        $('#dragonizer-import-btn').attr('disabled', 'disabled');
                    }
                });

                $('.dragonizer-upload-file').on('click', function() {
                    $('#dragonizer-import-file-input').val('').trigger('change');
                });

                $('#dragonizer-import-btn').on('click', function() {
                    dra_loader.removeClass("loaded");
                });

                $("#temporary_deactive").on("click", function(e) {
                    dra_loader.removeClass("loaded");
                });

                $("#export_settings").on("click", function(e) {
                    dra_loader.removeClass("loaded");
                    setTimeout(function() {
                        dra_loader.addClass("loaded");
                    }, 2000);
                });

                $.fn.shake = function(interval = 100, distance = 10, times = 4) {
                    var jTarget = $(this);
                    jTarget.css('position', 'relative');
                    for (var iter = 0; iter < (times + 1); iter++) {
                        jTarget.animate({
                            left: ((iter % 2 == 0 ? distance : distance * -1))
                        }, interval);
                    }
                    return jTarget.animate({
                        left: 0
                    }, interval);
                }

                var modal = $('#dragonizer-drag-dr-modal');
                var wrap = $('.drag-dr-modal-wrap');

                // Open modal
                $('#reset_settings').on('click', function(e) {
                    e.preventDefault();
                    modal.fadeIn('250');
                });

                // Close modal; Cancel
                modal.on('click', 'button.drag-dr-cancel-modal', function(e) {
                    e.preventDefault();
                    modal.fadeOut('250');
                })

                modal.on('click', function(e) {
                    e.preventDefault();
                    wrap.shake();
                }).on('click', 'div', function(e) {
                    e.stopPropagation();
                });

                var reset_url = '<?= add_query_arg(array('page' => "dragonizer_main", 'dragonizer_reset' => 'true', 'dragonizer_secret' => wp_create_nonce('dragonizer_reset')), admin_url('admin.php')); ?>';


                // Submit normal
                modal.on('click', 'button.drag-dr-submit-modal', function(e) {
                    e.preventDefault();
                    var button = $(this);
                    $(".drag-dr-modal-wrap").find("div").first().removeClass("drag-dr-hidden");
                    dra_loader.removeClass('loaded');
                    modal.fadeOut('250');
                    button.text('<?= __('Processing...', 'dragonizer') ?>');
                    button.addClass('disabled');
                    window.location.href = reset_url;
                });
            });
        }(jQuery));
    </script>
<?php
}
