<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_maintenance($obj)
{
?>
    <input type="hidden" name="dragonizer_settings[maintenance]" value="">

    <h3 class="dragon-hidden"><?php esc_html_e('Coming Soon & Maintenance Mode', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Fast, easy and safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php _e('If you have to close your website temporarily to the public, the native WordPress maintenance mode falls short and most coming soon plugins are bulky, incomplete or expensive. dragonizer maintenance mode is light, simple and versatile. <span style="color: #d94f4f">All users except administrator</span>', 'dragonizer'); ?></p>

    <br>

    <table class="dragon-hidden form-table">
        <tr>
            <th style="vertical-align: middle;" scope="row"><?php esc_html_e('Set site status', 'dragonizer'); ?></th>
            <td>
                <fieldset style="display:block" id="dragonizer_select_site_status">
                    <label>
                        <input id="online" name="dragonizer_settings[maintenance][site_status]" value="online" type="radio" <?php @checked($obj->final_settingsـmaintenance['site_status'], 'online', true); ?>>
                        <?php echo wp_kses(__('<strong>Online</strong> — WordPress works as usual', 'dragonizer'), array('strong' => array())); ?>
                    </label><br>

                    <label>
                        <input id="coming_soon" name="dragonizer_settings[maintenance][site_status]" value="coming_soon" type="radio" <?php @checked($obj->final_settingsـmaintenance['site_status'], 'coming_soon'); ?>>
                        <?php echo wp_kses(__('<strong>Coming soon</strong> — Site closed. All pages have a meta robots noindex, nofollow', 'dragonizer'), array('strong' => array())); ?>
                    </label><br>
                    <label>
                        <input id="maintenance" name="dragonizer_settings[maintenance][site_status]" value="maintenance" type="radio" <?php @checked($obj->final_settingsـmaintenance['site_status'], 'maintenance'); ?>>
                        <?php echo wp_kses(__('<strong>Maintenance</strong> — Site closed. All pages return 503 Service unavailable', 'dragonizer'), array('strong' => array())); ?>
                    </label><br>
                </fieldset>
            </td>
        </tr>

        <tr valign="top">
            <th style="vertical-align: middle;" scope="row"><?php esc_html_e('Magic Link', 'dragonizer'); ?></th>
            <td>
                <input type="hidden" name="dragonizer_settings[maintenance][token]" id="token_fld" value="<?php echo esc_attr($obj->final_settingsـmaintenance['token']); ?>">
                <a href="<?php echo esc_url($obj->magic_url); ?>" id="dragonizer_magic_link"><?php echo esc_url($obj->magic_url); ?></a>
                <button style="vertical-align: middle; margin: 10px;" name="change_token" id="change_token_btn" class="button action"><?php esc_html_e('change secret token', 'dragonizer'); ?></button>
                <p class="description"><?php _e('You can use this link to grant anyone access to the website when it is in maintenance mode. <br><span style="color: #d94f4f">Note that after entering with this link, the site will no longer be displayed in that browser in maintenance mode. (Secret token is stored in browser cookies)</span>', 'dragonizer'); ?></p>

            </td>
        </tr>

        <tr style="display: none;" valign="top">
            <th style="vertical-align: middle;" scope="row"><?php esc_html_e('Choose a page for the content', 'dragonizer'); ?></th>
            <td>
                <select name="dragonizer_settings[maintenance][page_id]" id="page_id_fld">
                    <option value=""><?php esc_html_e('Use dragonizer default content', 'dragonizer'); ?></option>
                    <?php
                    $dragonizer_pages = get_pages();
                    foreach ($dragonizer_pages as $dragonizer_page) {
                        echo '<option value="' . esc_attr($dragonizer_page->ID) . '" ' .
                            selected($dragonizer_page->ID, $obj->final_settingsـmaintenance['page_id']) . '>' .
                            esc_html($dragonizer_page->post_title) .
                            '</option>';
                    }
                    ?>
                </select>
            </td>
        </tr>

    </table>

    <script>
        (function($) {

            var dragonizer_preview_base_url = '<?php echo esc_url($obj->preview_base_url); ?>';
            var dragonizer_magic_base_url = '<?php echo esc_url($obj->magic_base_url); ?>';

            var random_token = function() {
                var chrs = '0123456789ABCDEF';
                var token = '';
                for (var i = 0, n = 12; i < n; i++) {
                    token += chrs.substr(Math.round(Math.random() * 15), 1);
                }
                return token;
            }

            $('#change_token_btn').click(function(e) {

                if (confirm('<?php esc_html_e('Are you sure you want to change the secret token?\nThis will invalidate previously-shared links.', 'dragonizer'); ?>')) {
                    var new_token = random_token();
                    var new_magic_url = dragonizer_magic_base_url + new_token;

                    $('#dragonizer_magic_link').attr('href', new_magic_url).html(new_magic_url);
                    $('#token_fld').val(new_token);
                }
                e.preventDefault();
                return;
            });
        })(jQuery);
    </script>

<?php
}
