<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_main($obj)
{
    $tab = str_replace('dragonizer_', '', sanitize_text_field($_GET['page']));

    $active_tab = array_key_exists($tab, $obj->get_tabs()) ? $obj->get_tabs()[$tab]['title'] : $obj->get_tabs()['main']['title'];

    if (is_multisite() && is_network_admin()) {
        $homeURL = add_query_arg(array('page' => 'dragonizer_main'), network_admin_url('admin.php'));
        $current_url = add_query_arg(array('page' => 'dragonizer_settings'), network_admin_url('admin.php'));
    } elseif (!is_multisite()) {
        $homeURL = add_query_arg(array('page' => 'dragonizer_main'), admin_url('admin.php'));
        $current_url = add_query_arg(array('page' => 'dragonizer_settings'), admin_url('admin.php'));
    }

    $homeURL = add_query_arg(array('page' => 'dragonizer_main'), admin_url('admin.php'));
    $current_url = add_query_arg(array('page' => 'dragonizer_settings'), admin_url('admin.php'));

?><style>
        input#submit {
            display: initial !important;
        }
    </style>

    <script>
        (function($) {
            $(document).ready(function() {
                var $tabContent = $(".dragonizer_tab_content"); // Cache the selector for performance

                // Code for handling "check all" functionality with delegation from dragonizer_tab_content
                $tabContent.on('change', 'input[type="checkbox"][name="check_all"]', function() {
                    var allChecked = $(this).prop('checked'); // true if "check all" is checked, false otherwise
                    $(this).closest('table').find('tbody .check-column input[type="checkbox"]').prop('checked', allChecked);
                });

                $tabContent.on('change', 'tbody .check-column input[type="checkbox"]', function() {
                    var $table = $(this).closest('table');
                    var allCheckboxes = $table.find('tbody .check-column input[type="checkbox"]');
                    var allChecked = allCheckboxes.length === $table.find('tbody .check-column input[type="checkbox"]:checked').length;

                    $table.find('thead input[type="checkbox"][name="check_all"]').prop('checked', allChecked);
                });
            });

        }(jQuery));
    </script>
    <div class="wrap dragonizer_wrap dragonizer-settings-wrap">

        <div class="dragonizer_wrap__main">

            <div class="wp-header-end"></div>

            <div class="dragon-hidden" style="display: flex; align-items: center;">
                <a href="<?= esc_url(add_query_arg(array('page' => 'dragonizer_main'), admin_url('admin.php'))) ?>">
                    <img style="margin-left:1em;margin-right:1em;width:75px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') ?>?ver=<?= DRAGONIZER_VER ?>" alt="">
                </a>
                <div>
                    <h2 style="font-weight: bold; font-size: 2em; display: inline-block;"><?= __('Dragonizer', 'dragonizer') ?></h2>
                    <span style="float: <?= is_rtl() ? 'left' : 'right' ?>; display: inline-flex; min-height: 50px; align-items: end;"><?= sprintf(__('(Version : %1$s)', 'dragonizer'), DRAGONIZER_VER) ?></span>
                    <p style="width: 100%;margin-top:-1em; display: flex; align-items: center;"><?= __('Your assistant to make WordPress more powerful', 'dragonizer') ?></p>
                </div>
            </div>

            <div class="dragonizer_tab_group">

                <div id="loader-wrapper">

                    <div class="logo-loader-pulsate">
                        <img class="logo-loader-logo-front" src="<?= _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') ?>?ver=<?= DRAGONIZER_VER ?>" alt="dragonizer">
                        <img class="logo-loader-logo-behind" src="<?= _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') ?>?ver=<?= DRAGONIZER_VER ?>" alt="dragonizer">
                    </div>

                    <div class="loader-section section-left"></div>
                    <div class="loader-section section-right"></div>

                </div>

                <ul class="dragonizer_tab dragon-hidden">
                    <?php
                    foreach ($obj->get_tabs() as $tab_id => $tab_name) {

                        $tab_name = $tab_name['title'];

                        $tab_url = add_query_arg([
                            'page' => 'dragonizer_' . $tab_id
                        ]);

                        $active = $tab === $tab_id ? 'active' : '';
                        $IsNewTab = in_array($tab_id, $obj->get_new_tabs(), true) ? ' is-pro-tab' : '';
                        $IsSoonTab = in_array($tab_id, $obj->get_soon_tabs(), true) ? ' is-pro-tab' : '';
                        $proLockIcon = '';

                        // if (false and $IsProTab) {
                        //     if ($obj->is_pro_installed()) {
                        //         $proLockIcon = '</a><span class="pro-installed"><a href="' . DRAGONIZER_DIR . '" target="_blank"><span class="dashicons dashicons-unlock"></span> Pro</a></span></li>';
                        //     } else {
                        //         $proLockIcon = '</a><span class="pro-not-installed"><a href="' . DRAGONIZER_DIR . '" target="_blank"><span class="dashicons dashicons-lock"></span> Pro</a></span></li>';
                        //     }
                        // } else 
                        if ($IsSoonTab) {
                            $proLockIcon = '</a><span class="comming-soon"><a href="' . DRAGONIZER_DIR . '" target="_blank"><span class="dashicons dashicons-clock"></span> ' . __('Soon', 'dragonizer') . '</a></span></li>';
                        }
                        if ($IsNewTab) {
                            $proLockIcon = '</a><span class="comming-soon"><a href="' . DRAGONIZER_DIR . '" target="_blank"><span class="dashicons dashicons-star-filled"></span> ' . __('New', 'dragonizer') . '</a></span></li>';
                        }

                        echo '<li class="tab-' . $tab_id . $IsNewTab . '"><a href="' . esc_url($tab_url) . '" title="' . esc_attr($tab_name) . '" class="' . $active . '">';
                        echo $tab_name;
                        echo '</a>' . $proLockIcon . '</li>';
                    }
                    ?>
                    <li class="tab-link"><a target="_blank" href="https://www.rtl-theme.com/dragonizer-wordpress-plugin"><?= __('Dragonizer in rtl-theme.com', 'dragonizer') ?></a></li>

                    <li class="tab-company-logo">
                        <a target="_blank" href="https://ardyn.ir">
                            <img src="<?= _dr(DRAGONIZER_URL, '/assets/images/logo/typography.png') ?>?ver=<?= DRAGONIZER_VER ?>" />
                        </a>
                    </li>

                </ul>

                <div class="dragonizer_tab_content"><?php
                                                    if ($tab === 'main') {
                                                        echo $obj->temp_echo($tab);
                                                        echo $obj->generate_all_modules($tab, $active_tab);
                                                    } else {
                                                        echo $obj->temp_echo($tab);
                                                        echo $obj->generate_settings($tab, $active_tab);
                                                    }
                                                    ?></div>
            </div>
        </div>
    </div><?php
        }
