<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_login_customizer($obj)
{
    $dragonizer_allowed_description_tags = array(
        'em'     => array(),
        'strong' => array(),
        'br'     => array(),
        'span'   => array(
            'style' => array()
        ),
        'a'      => array(
            'href' => array()
        ),
        'p'      => array(
            'style' => array()
        )
    );

    wp_enqueue_media();
    wp_enqueue_script('wp-color-picker');

    $temp = $obj->final_settings_login_customizer['template'] ?? '';

?>

    <input type="hidden" name="dragonizer_settings[login_customizer]" value="">

    <h3 class="dragon-hidden"><?php esc_html_e('Your WordPress login page customizer', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Fast, easy and safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('This section allows you to easily customize your admin login page according to your needs. Add your company logo to login screen, change background colors, styles, button color etc.', 'dragonizer'); ?></p>

    <br>

    <table class="dragon-hidden form-table invisible-table">
        <tbody>
            <tr>
                <td colspan="3">
                    <h3><?php esc_html_e('Select a template for your login page', 'dragonizer'); ?></h3>
                    <section class="plan">
                        <?php
                        foreach ($obj->login_customizer as $dragonizer_template_slug => $dragonizer_template_value) {
                        ?>
                            <input type="radio" name="dragonizer_settings[login_customizer][template]" id="<?= $dragonizer_template_slug ?>" value="<?= $dragonizer_template_slug ?>" <?php @checked(true, $dragonizer_template_slug == $temp, true); ?>>
                            <label class="col" for="<?= $dragonizer_template_slug ?>">
                                <img src="<?= $dragonizer_template_value['thumbnail'] ?>">
                            </label>
                        <?php
                        }
                        ?>
                    </section>
                </td>
            </tr>

            <tr>
                <td>
                    <h3><?php esc_html_e('Choose your logo', 'dragonizer'); ?><span style="font-size: small;"><?php echo esc_html__('  (optional)', 'dragonizer'); ?></span></h3>
                    <div class="preview">
                        <img style="height: 70px; width:100%; margin-top: -26%;" id="thumb_lg" width="50px" height="50px" src="" />
                    </div>
                    <div>
                        <input id="logo_lg" type="text" size="36" readonly name="dragonizer_settings[login_customizer][logo]"
                            value="<?php echo isset($obj->final_settings_login_customizer['logo']) ? esc_attr($obj->final_settings_login_customizer['logo']) : ''; ?>" />
                        <input id="logo_button_lg" class="button" type="button" value="<?php echo esc_attr__('Upload Image', 'dragonizer'); ?>" />
                        <input id="logo_clear_lg" class="button" type="button" value="<?php echo esc_attr__('Clear', 'dragonizer'); ?>" />
                    </div>
                </td>
            </tr>
            <tr id="bg-selector">
                <td>
                    <h3><?php esc_html_e('Choose a background', 'dragonizer'); ?><span style="font-size: small;"><?php echo esc_html__('  (optional)', 'dragonizer'); ?></span></h3>
                    <div class="preview">
                        <img style="height: 70px; width:100%; margin-top: -26%;" id="thumb_bg" width="50px" height="50px" src="" />
                    </div>
                    <div>
                        <input id="logo_bg" type="text" size="36" readonly name="dragonizer_settings[login_customizer][background]"
                            value="<?php echo isset($obj->final_settings_login_customizer['background']) ? esc_attr($obj->final_settings_login_customizer['background']) : ''; ?>" />
                        <input id="logo_button_bg" class="button" type="button" value="<?php echo esc_attr__('Upload Image', 'dragonizer'); ?>" />
                        <input id="logo_clear_bg" class="button" type="button" value="<?php echo esc_attr__('Clear', 'dragonizer'); ?>" />
                    </div>
                </td>
            </tr>

            <?php

            switch ($temp) {
                case 'template-01':
                    $defaultColor = '#9d0110';
                    break;
                case 'template-02':
                    $defaultColor = '#a07500';
                    break;
                case 'template-03':
                    $defaultColor = '#F89269';
                    break;
                case 'template-04':
                    $defaultColor = '#2e3f4e';
                    break;
                case 'template-05':
                    $defaultColor = '#00594b';
                    break;
                case 'default':
                    $defaultColor = '';
                    break;
            }
            ?>

            <tr id="color-selector">
                <td>
                    <h3><?php esc_html_e('Choose your base color', 'dragonizer'); ?><span style="font-size: small;"><?= __('  (optional)', 'dragonizer'); ?></span></h3>
                    <div id="color-picker-container">
                        <input type="text" value="<?= @$obj->final_settings_login_customizer['color'] ?? $defaultColor ?>" data-default-color="<?= $defaultColor ?>" name="dragonizer_settings[login_customizer][color]" id="color-picker" />
                    </div>
                </td>
            </tr>

            <tr>
                <td>
                    <h3><?php esc_html_e('Other options', 'dragonizer'); ?></h3>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_optimize-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->login_customizer_opts, 'login_customizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->login_customizer_opts as $dragonizer_option_slug => $dragonizer_option) {
                if (empty($dragonizer_option['type'])) {
            ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['login_customizer'] ?? null) ? $obj->settings['login_customizer'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>
                <?php } else {
                ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['login_customizer'][$dragonizer_option_slug] ?? null) ? $obj->settings['login_customizer'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                            <bdo style="direction:ltr;display:flex;align-items:center;justify-content:<?= is_rtl() ? 'right' : 'left' ?>">

                                <?php if ($dragonizer_option_slug == 'custom_login') { ?>

                                    <?php if (get_option('permalink_structure')) { ?>
                                        <code><?= trailingslashit(home_url()) ?></code> <input style="margin:4px;width:100px" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" type="text" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug  ?>][value]" value="<?= $obj->settings['login_customizer'][$dragonizer_option_slug]['value'] ?? 'securelogin' ?>">
                                    <?php  } else {  ?>
                                        <code><?= trailingslashit(home_url()) ?><span style="color: red;">?</span></code> <input style="margin:4px;width:100px" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" type="text" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug  ?>][value]" value="<?= $obj->settings['login_customizer'][$dragonizer_option_slug]['value'] ?? 'securelogin' ?>">
                                    <?php  }  ?>

                                <?php  } else {  ?>

                                    <?php if (get_option('permalink_structure')) { ?>
                                        <code><?= trailingslashit(home_url()) ?></code> <input style="margin:4px;width:100px" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" type="text" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug  ?>][value]" value="<?= $obj->settings['login_customizer'][$dragonizer_option_slug]['value'] ?? '404' ?>">
                                    <?php  } else {  ?>
                                        <code><?= trailingslashit(home_url()) ?><span style="color: red;">?</span></code> <input style="margin:4px;width:100px" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" type="text" name="dragonizer_settings[login_customizer][<?= $dragonizer_option_slug  ?>][value]" value="<?= $obj->settings['login_customizer'][$dragonizer_option_slug]['value'] ?? '404' ?>">
                                    <?php  }  ?>

                                <?php  }  ?>

                            </bdo>
                            <br>
                            <?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?>
                        </td>
                    </tr>
            <?php
                }
            } ?>
        </tbody>
    </table>

    <script>
        jQuery(document).ready(function($) {

            $(function() {
                $("#color-picker").wpColorPicker({
                    palettes: ['#9d0110', '#F89269', '#a07500', '#2e3f4e', '#00594b']
                });

                if ($("input[type='radio']#default").is(":checked")) {
                    $("#bg-selector,#color-selector").each(function() {
                        $(this).hide();
                    });
                }
            });

            $("input[type='radio']").on("click", function() {

                if ($(this).attr('id') === "default") {

                    $("#bg-selector,#color-selector").each(function() {
                        $(this).hide();
                    });

                } else {

                    $("#bg-selector,#color-selector").each(function() {
                        $(this).show();
                    });

                    switch ($(this).attr('id')) {
                        case "template-01":
                            $(".wp-picker-container").remove();
                            $('<input type="text" value="#9d0110" data-default-color="#9d0110" name="dragonizer_settings[login_customizer][color]" id="color-picker" />').appendTo($("#color-picker-container"));
                            break;
                        case "template-02":
                            $(".wp-picker-container").remove();
                            $('<input type="text" value="#a07500" data-default-color="#a07500" name="dragonizer_settings[login_customizer][color]" id="color-picker" />').appendTo($("#color-picker-container"));
                            break;
                        case "template-03":
                            $(".wp-picker-container").remove();
                            $('<input type="text" value="#F89269" data-default-color="#F89269" name="dragonizer_settings[login_customizer][color]" id="color-picker" />').appendTo($("#color-picker-container"));
                            break;
                        case "template-04":
                            $(".wp-picker-container").remove();
                            $('<input type="text" value="#2e3f4e" data-default-color="#2e3f4e" name="dragonizer_settings[login_customizer][color]" id="color-picker" />').appendTo($("#color-picker-container"));
                            break;
                        case "template-05":
                            $(".wp-picker-container").remove();
                            $('<input type="text" value="#00594b" data-default-color="#00594b" name="dragonizer_settings[login_customizer][color]" id="color-picker" />').appendTo($("#color-picker-container"));
                            break;
                    }

                    $(function() {
                        $("#color-picker").wpColorPicker({
                            palettes: ['#9d0110', '#F89269', '#a07500', '#2e3f4e', '#00594b']
                        });
                    });
                }
            });

            var src_img = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEYAAABGBAMAAACDAP+3AAAALVBMVEXMzMzu7u7v7+/b29vPz8/S0tLf39/W1tbs7Ozp6enm5ubr6+vh4eHa2trj4+MfA+qxAAABSklEQVRIx2MYBUMY+J56FkBACfMmJSU5AooeKQoKCm3Fq4RNURAINB3wqQkUBAGhBHxqDgmCwRZ8aiZB1KjjUcKyEaJGlxg1FNrFkESEmyOgfqc0DBkOgeJiKhFx6kAobeQdDiA6IYUToWaFA0ElbEoHCKopFBQnpIRlkqAWITU8ioJCBgTUXAIGdyt+JayNQDV62GS8CmAsLnC8FWBLGcIoaURoCjYLhI5AWOyQZKSGkEOyQAsSV56KYDUSAdj8IrQdOQsJLcAMNqCwIihQeBUFoWkfexrUcYCmWESCxEzLSxkYFgFpbAkbLqNdADQQClDjFeEIoeZCuBL0ePWE626EK0GP1yRBbKAVIxYxgR5aIGMDQsjxWoQpD49XRCBjB2oogYwB0OM1AlMWI14fYcqixys7plUY8eqthBPA82uwMW5gwjAKhhoAAPwIVYT7VY3XAAAAAElFTkSuQmCC';
            if ($('#logo_lg').val()) {
                $('img#thumb_lg').attr('src', $('#logo_lg').val());
            } else {
                $('img#thumb_lg').attr('src', src_img);
            }
            $('#logo_clear_lg').click(function(e) {
                $('#logo_lg').val('');
                $('img#thumb_lg').attr('src', src_img);
            });
            var custom_uploader1;
            $('#logo_button_lg').click(function(e) {
                e.preventDefault();
                if (custom_uploader1) {
                    custom_uploader1.open();
                    return;
                }
                custom_uploader1 = wp.media.frames.file_frame = wp.media({
                    title: '<?= __('Choose Image', 'dragonizer'); ?>',
                    library: {
                        type: 'image'
                    },
                    button: {
                        text: '<?= __('Choose Image', 'dragonizer'); ?>'
                    },
                    multiple: false,
                    displaySettings: true,
                    displayUserSettings: false
                });
                custom_uploader1.on('select', function() {
                    attachment = custom_uploader1.state().get('selection').first().toJSON();
                    $('#logo_lg').val(attachment.url);
                    $('img#thumb_lg').attr('src', attachment.url);
                });
                custom_uploader1.on('close', function() {
                    if (custom_uploader1.state().get('selection').length == 0) {
                        $('#logo_lg').val('');
                        $('img#thumb_lg').attr('src', src_img);
                    }
                });
                custom_uploader1.open();
            });


            var custom_uploader2;
            if ($('#logo_bg').val()) {
                $('img#thumb_bg').attr('src', $('#logo_bg').val());
            } else {
                $('img#thumb_bg').attr('src', src_img);
            }
            $('#logo_clear_bg').click(function(e) {
                $('#logo_bg').val('');
                $('img#thumb_bg').attr('src', src_img);
            });
            var custom_uploader2;
            $('#logo_button_bg').click(function(e) {
                e.preventDefault();
                if (custom_uploader2) {
                    custom_uploader2.open();
                    return;
                }
                custom_uploader2 = wp.media.frames.file_frame = wp.media({
                    title: '<?= __('Choose Image', 'dragonizer'); ?>',
                    library: {
                        type: 'image'
                    },
                    button: {
                        text: '<?= __('Choose Image', 'dragonizer'); ?>'
                    },
                    multiple: false,
                    displaySettings: true,
                    displayUserSettings: false
                });
                custom_uploader2.on('select', function() {
                    attachment = custom_uploader2.state().get('selection').first().toJSON();
                    $('#logo_bg').val(attachment.url);
                    $('img#thumb_bg').attr('src', attachment.url);
                });
                custom_uploader2.on('close', function() {
                    if (custom_uploader2.state().get('selection').length == 0) {
                        $('#logo_bg').val('');
                        $('img#thumb_bg').attr('src', src_img);
                    }
                });
                custom_uploader2.open();
            });
        });
    </script>

<?php
}
