<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_copyright($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'b'   => array(),
        'em'     => array(),
        'strong' => array(),
        'a'      => array(
            'href' => array()
        ),
        'p'      => array(
            'style' => array()
        ),
        'span' => array(
            'style' => array(),
            'class' => array(),
        ),
    );

?>

    <input type="hidden" name="dragonizer_settings[copyright]" value="">

    <h3 class="dragon-hidden"><?php esc_html_e('Protect your site content', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

    <p class="dragon-hidden"><?php esc_html_e('This section protect your site content by multiple techniques (JavaScript + CSS) from being copied by any other web site author, if you don\'t want your content to spread without your permission!', 'dragonizer'); ?></p>

    <br>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->copyright, 'copyright'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->copyright as $dragonizer_option_slug => $dragonizer_option) {
                if (empty($dragonizer_option['type'])) {
            ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[copyright][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['copyright'] ?? null) ? $obj->settings['copyright'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>
                <?php
                } elseif ($dragonizer_option['type'] === 'editor') {
                ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[copyright][<?= $dragonizer_option_slug ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>" <?php @checked(true, array_key_exists('status', (is_array($obj->settings['copyright'][$dragonizer_option_slug] ?? null) ? $obj->settings['copyright'][$dragonizer_option_slug] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary">
                            <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row">
                                <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                            </button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                            <?php

                            $content_db = @wp_kses(html_entity_decode($obj->get('copyright', $dragonizer_option_slug, 'value')), $dragonizer_allowed_description_tags);

                            $content = empty($content_db) ? __($dragonizer_option['default'], 'dragonizer') : $content_db;

                            echo $obj->safe_wp_editor(
                                $content,
                                esc_attr($dragonizer_option_slug . '_fld'),
                                array(
                                    'media_buttons' => false,
                                    'textarea_name' => "dragonizer_settings[copyright][$dragonizer_option_slug][value]",
                                    'editor_height' => $dragonizer_option['height'],
                                    'editor_css'    => '<style>.wp-editor-container textarea.wp-editor-area{direction: ltr;}</style>',
                                    'tinymce' => array(
                                        'toolbar1' => 'bold,italic,underline,separator,link,unlink,undo,redo,forecolor,removeformat,charmap',
                                        'toolbar2' => ''
                                    ),
                                    'quicktags' => array(
                                        'buttons' => 'link,strong,em,underline'
                                    )
                                )
                            );

                            echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags);

                            ?>
                        </td>
                    </tr>
            <?php
                }
            } ?>
        </tbody>
    </table>

<?php
}
