<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_benchmark($obj)
{
    include_once _dr(DRAGONIZER_INC_DIR, 'class-dragonizer-benchmark.php');

    if (class_exists('Dragonizer_Benchmark_Infomation')) {
?>
        <h3 class="dragon-hidden"> <?php esc_html_e('Server Information', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"> <?php esc_html_e('Usually accurate', 'dragonizer'); ?> </span> </h3>

        <p class="dragon-hidden"> <?php esc_html_e('This section provides a detailed overview of your hosting server’s environment,', 'dragonizer'); ?> </p>

        <br>

        <?php
        (new Dragonizer_Benchmark_Infomation())->show();
        ?>
        <h3 class="dragon-hidden"><?php esc_html_e('Server Performance Benchmark', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Usually accurate', 'dragonizer'); ?></span></h3>

        <p class="dragon-hidden"><?php esc_html_e('This section analyzes your server\'s performance using advanced benchmarking. It evaluates key metrics, highlights strengths, and points out areas for improvement, aiding in better decision-making for upgrades.', 'dragonizer'); ?></p>

        <br>


    <?php
        (new Dragonizer_Benchmark())->initialize();
    } else {
    ?>
        <p class="dragon-hidden"><?php esc_html_e('An error has occurred. Please refresh the page by pressing F5', 'dragonizer'); ?></p>
<?php
    }
}
