<?php

/**
 * Dragonizer Advanced Headers Test
 * Use this file to test the HTTP security headers set by the Dragonizer Plugin.
 * Directly access this file for testing. Do not load during regular WordPress execution.
 */

// Function to check if SSL is enabled
function dragonizer_is_ssl()
{
	$sslHeaders = [
		'HTTPS' => 'on',
		'SERVER_PORT' => 443,
		'HTTP_X_FORWARDED_PROTO' => 'https',
		'HTTP_X_FORWARDED_SSL' => 'on',
		'HTTP_FRONT_END_HTTPS' => 'on',
		'HTTP_X_URL_SCHEME' => 'https',
	];

	// Check for SSL headers
	foreach ($sslHeaders as $header => $value) {
		if (isset($_SERVER[$header]) && strtolower($_SERVER[$header]) === $value) {
			return true;
		}
	}

	return false;
}

$headerTestPassed = false;

// Set HTTP Headers
if (!headers_sent()) {
	if (dragonizer_is_ssl()) {
		// Strict-Transport-Security Header
		header('Strict-Transport-Security: max-age=63072000; includeSubDomains; preload');
	}

	// Other Security Headers
	header('X-XSS-Protection: 1; mode=block');
	header('X-Content-Type-Options: nosniff');
	header('Referrer-Policy: no-referrer-when-downgrade');
	header('Expect-CT: max-age=7776000, enforce');
	header('X-Frame-Options: SAMEORIGIN');
	header('Cross-Origin-Opener-Policy: unsafe-none');
	header('Access-Control-Allow-Origin: cross-origin');
	header('Cross-Origin-Resource-Policy: cross-origin');
	header('Permissions-Policy: accelerometer=(self), autoplay=(self), camera=(self), encrypted-media=(self), fullscreen=(self), geolocation=(self), gyroscope=(self), magnetometer=(self), microphone=(self), midi=(self), payment=(self), picture-in-picture=(self), sync-xhr=(self), usb=(self)');
	header('Content-Security-Policy: report-uri https://ardyn.ir/wp-plugins/personal;');
	header('X-Permitted-Cross-Domain-Policies: none');

	// Custom Dragonizer Test Header
	header('X-Dragonizer-Test: Successful');

	$headerTestPassed = true;
}

$status = $headerTestPassed ? "Header Test Successful" : "Header Test Failed";
$backgroundColor = $headerTestPassed ? 'rgba(9, 189, 9, 0.88);' : 'rgba(255, 0, 0, 0.68);';

function dr_die_array($input, string $title = '', bool $die = true): void
{
	echo "<h4>$title</h4>";
	echo '<pre>';
	is_array($input) ? var_export($input) : var_dump($input);
	echo '</pre><br>';
	$die and die;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Dragonizer Header Test</title>
	<style>
 		body{display:flex;position:relative;background:<?php echo $backgroundColor;?>}main{position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);display:flex;flex-direction:column;text-align:center;width:90%}#img{height:120px;width:120px;border-radius:30%}h1{text-align:center;font-size:35px;color:white}p{text-align:center;font-size:20px;color:white}
	</style>
</head>

<body>
	<main>
		<span>
			<?php if ($headerTestPassed) : ?>
				<svg xmlns='http://www.w3.org/2000/svg' width='128' height='128' fill='none' viewBox='0 0 24 24'><g stroke='#fff' stroke-linejoin='round' stroke-width='2.5' clip-path='url(#a)'><path d='M5.606 5.74 12 3l6.394 2.74a1 1 0 0 1 .606.92v6.858a6 6 0 0 1-3.023 5.21L12 21l-3.977-2.273A6 6 0 0 1 5 13.518V6.66a1 1 0 0 1 .606-.919Z' /><path stroke-linecap='round' d='m15 10-4 4-2-2' /></g><defs><clipPath id='a'><path fill='#fff' d='M0 0h24v24H0z' /></clipPath></defs></svg>
			<?php else : ?>
				<svg xmlns='http://www.w3.org/2000/svg' width='128' height='128' fill='none' viewBox='0 0 24 24'><g stroke='#fff' stroke-linejoin='round' stroke-width='2.5' clip-path='url(#a)'><path d='M5.606 5.74 12 3l6.394 2.74a1 1 0 0 1 .606.92v6.858a6 6 0 0 1-3.023 5.21L12 21l-3.977-2.273A6 6 0 0 1 5 13.518V6.66a1 1 0 0 1 .606-.919Z' /><path stroke-linecap='round' d='m10 10 4 4m-4 0 4-4' /></g><defs><clipPath id='a'><path fill='#fff' d='M0 0h24v24H0z' /></clipPath></defs></svg>
			<?php endif; ?>
		</span>
		<bdo style='direction:ltr'>
			<h1 class="<?php echo $headerTestPassed ? 'success' : 'failure'; ?>"><?php echo $status; ?></h1>
			<p>This page is used to test the security headers set by the Dragonizer Plugin.</p>
		</bdo>
	</main>
</body>

</html>