<?php

// If this file is called directly, abort.
defined('ABSPATH') || die('No direct access!');

class Dragonizer_Maintenance
{
    private static $options;

    public function init($options)
    {
        if (empty($options) || !empty(self::$options)) {
            return;
        }

        $default = [
            'token'       => '',
            'site_status' => '',
        ];

        self::$options = dr_fix_settings($default, $options);

        if (is_admin_bar_showing() && is_user_logged_in()) {

            if (in_array($this->settings()->site_status, ['coming_soon', 'maintenance'])) {

                if (is_admin()) {
                    add_action('admin_enqueue_scripts', [$this, 'admin_bar_scripts']);
                } else {
                    add_action('wp_enqueue_scripts', [$this, 'admin_bar_scripts']);
                }

                if ('maintenance' === $this->settings()->site_status) {
                    add_action('admin_bar_menu', [$this, 'dragonizer_maintenance_admin_bar'], 9);
                } elseif ('coming_soon' === $this->settings()->site_status) {
                    add_action('admin_bar_menu', [$this, 'dragonizer_coming_soon_admin_bar'], 9);
                }
            } else {
                add_action('admin_bar_menu', [$this, 'dragonizer_online_admin_bar'], 9);
            }
        }

        if (in_array($this->settings()->site_status, ['coming_soon', 'maintenance'])) {
            if (function_exists('bp_is_active')) {
                add_action('template_redirect', array($this, 'render_comingsoon_page'), 9);
            } else {
                add_action('template_redirect', array($this, 'render_comingsoon_page'));
            }
        }
    }

    private function settings(): object
    {
        if (is_object(self::$options)) {
            return self::$options;
        } else {
            return (object)[];
        }
    }

    public function admin_bar_scripts()
    {
        wp_register_style('dragonizer_maintenance_bar_styles', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'css', 'dragonizer-maintenance-bar.min.css'), true), array(), DRAGONIZER_VER);
        wp_enqueue_style('dragonizer_maintenance_bar_styles');
    }

    public function dragonizer_maintenance_admin_bar()
    {
        global $wp_admin_bar;

        if (current_user_can('manage_options')) {
            $href = admin_url('admin.php?page=dragonizer_maintenance');
        } else {
            $href = admin_url('index.php');
        }

        // Adds the main admin menu item.
        $wp_admin_bar->add_menu(
            array(
                'id' => 'dragonizer_maintenance_notice',
                'href' => $href,
                'parent' => 'top-secondary',
                'title' => __('Maintenance Mode', 'dragonizer'),
                'meta' => array('class' => 'dragonizer_maintenance_active'),
            )
        );
    }

    public function dragonizer_coming_soon_admin_bar()
    {
        global $wp_admin_bar;

        if (current_user_can('manage_options')) {
            $href = admin_url('admin.php?page=dragonizer_maintenance');
        } else {
            $href = admin_url('index.php');
        }

        // Adds the main admin menu item.
        $wp_admin_bar->add_menu(
            array(
                'id' => 'dragonizer_maintenance_notice',
                'href' => $href,
                'parent' => 'top-secondary',
                'title' => __('Coming Soon Mode', 'dragonizer'),
                'meta' => array('class' => 'dragonizer_coming_soon_active'),
            )
        );
    }

    function dragonizer_online_admin_bar()
    {
        global $wp_admin_bar;

        if (current_user_can('manage_options')) {
            $href = admin_url('admin.php?page=dragonizer_maintenance');
        } else {
            $href = admin_url('index.php');
        }

        // Adds the main admin menu item.
        $wp_admin_bar->add_menu(
            array(
                'id' => 'dragonizer_maintenance_notice',
                'href' => $href,
                'parent' => 'top-secondary',
                'title' => __('Online', 'dragonizer'),
                'meta' => array('class' => 'dragonizer_online_active'),
            )
        );
    }

    public function render_comingsoon_page()
    {
        // Check if Preview.
        $is_preview = false;
        if (null !== filter_input(INPUT_GET, 'mct_preview')) {
            $is_preview = true;
        }

        if (!$is_preview) {
            // Exit if a custom login page.
            if (preg_match('/wp\-login\.php|wp\-admin/i', filter_input(INPUT_SERVER, 'REQUEST_URI')) > 0) {
                return false;
            }

            // Exit if user is logged in.
            if (is_user_logged_in() && current_user_can('manage_options')) {
                return false;
            }
        }

        $mct_token = filter_input(INPUT_GET, 'mct_token');
        $mct_cookie = filter_input(INPUT_COOKIE, 'mct_cookie');

        if (('logout' === $mct_token) && (null !== $mct_cookie)) {
            $mct_cookie = null;
            setcookie('mct_cookie', '', time() - 3600);
        }

        // checks magic link cookie.
        if ($mct_cookie === $this->settings()->token) {
            return false;
        }

        // checks magic link.
        if ($mct_token === $this->settings()->token) {
            // Saves session cookie.
            setcookie('mct_cookie', $mct_token);
            return false;
        }

        if ('coming_soon' === $this->settings()->site_status) {
            // Coming soon default content.
            $html_content = array(
                'title' => __('Coming soon', 'dragonizer'),
                'body' => __('<h1>Under construction</h1><h3>New content is coming soon...</h3>', 'dragonizer'),
                'content_class' => 'default',
            );
        } else {
            // Maintenance default content.
            $html_content = array(
                'title' => __('Maintenance', 'dragonizer'),
                'body' => __('<h1>Under maintenance</h1><h3>We will be back shortly</h3>', 'dragonizer'),
                'content_class' => 'default',
            );
        }

        if (is_rtl()) {
            $html_content['body_class'] = 'rtl';
        } else {
            $html_content['body_class'] = '';
        }

        defined('DONOTCACHEPAGE') || define('DONOTCACHEPAGE', true);
        include_once _dr(DRAGONIZER_PAR_DIR, 'maintenance-template', 'dragonizer-maintenance-template.php');
        display_maintenance($html_content, $this->settings());
        exit();
    }
}
